/***************************************************************************
 *   Copyright (C) 2009 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *   and Andreas Bresser bresser@informatik.uni-bremen.de                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "Logger.h"

Logger::Logger(cSettings * settings, sMode * mode)
{
    csv = new CSVLogger(settings, mode);
    logger << csv;
    active = false;
}

Logger::~Logger()
{
    close();
}

//schreibe log
void Logger::write(int * analogData)
{
    if (active == true)
        foreach (DefaultLogger * log, logger)
            if (log->ready())
                log->write(analogData);
}

//starte Logging
void Logger::start_Log()
{
    active = true;
    foreach (DefaultLogger * log, logger)
        log->newLog();
}

//soll geloggt werden?
bool Logger::is_active()
{
    return active;
}

//alles schließen
void Logger::close()
{
    active = false;
    foreach (DefaultLogger * log, logger)
        log->close();
}
